#ifndef lint
static char *sccsid = "@(#) 2.4 src/somples.os2/somd/c/event/eventsvr.c, somx, som2.0.fix, csd2.0.4 4/14/94 11:35:03 [5/23/94 10:02:05]";
#endif

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


#ifndef _ALL_SOURCE
#define _ALL_SOURCE
#endif

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>

#include <somd.h>
#include <orb.h>

#include <impldef.h>
#include <implrep.h>

#include <intfacdf.h>
#include <somdom.h>

#include "cell.h"
#include "eventcom.h"
#include "eventch.h"

extern SOMOA                     SOMD_SOMOAObject;
extern ORB                       SOMD_ORBObject;
extern ImplementationDef         SOMD_ImplDefObject;
extern SOMDObjectMgr             SOMD_ObjectMgr;
extern int SOM_TraceLevel;
extern int somdCommDebugFlag;

Environment       ev;

/* function prototypes */
void exitUsage(char *prog);
int  write_obj_ref(SOMDObject objref, char *file);


int main(int argc, char **argv)
{
    char              *penv, *alias;
    int               rc;
    Cell              cellObj;
    SOMDObject        cellObj_proxy, evchObj_proxy;
    EventChannelAdmin_EventChannel      evchObj;
    EventChannelAdmin_SupplierAdmin     supp_admin;
    EventComm_EventConnection   evcon_if;
    EventComm_Consumer          cons_if;


    SOM_TraceLevel = 0;
    somdCommDebugFlag = 0;

    penv = (char *) getenv("SOM_TRACELEVEL");
    if (penv != NULL)
      SOM_TraceLevel = atoi(penv);

    penv = (char *) getenv("SOMDCOMMDEBUGFLAG");
    if (penv != NULL)
      somdCommDebugFlag = atoi(penv);

    /* Parse arguments */
    switch (argc)
    {
      case 2:
	alias = argv[1];
	break;

      default:
	printf("\n Invalid number of arguments");
	exitUsage(argv[0]);
    }

    EventComm_EventConnectionNewClass(0,0);

    SOM_InitEnvironment(&ev);
    SOMD_Init(&ev);
    SOMD_ImplDefObject = _find_impldef_by_alias(SOMD_ImplRepObject, &ev, alias);
    SOMD_SOMOAObject =  SOMOANew();

    if ((SOMD_ImplDefObject == NULL) ||         /* The initialization failed */
	(SOMD_ORBObject     == NULL))
    {
       printf("Event Server Initialization Failed\n");
    }
    else
    {
       SOMOA_impl_is_ready(SOMD_SOMOAObject, &ev, SOMD_ImplDefObject);

       /* Create the cell object  */
       cellObj = CellNew();

       /*  Create a DSOM object reference for the cellObj  */
       cellObj_proxy = SOMOA_create_SOM_ref(SOMD_SOMOAObject, &ev,
						 cellObj,
						 SOMD_ImplDefObject);

       /*  Create EventChannel object  */
       evchObj = EventChannelAdmin_EventChannelNew();

       /*  Create a DSOM object reference for evch  */
       evchObj_proxy = SOMOA_create_SOM_ref(SOMD_SOMOAObject, &ev, evchObj,
					    SOMD_ImplDefObject);

       /*
	* Get a supplier admin obj and add a push style supplier onto the
	* event channel using this admin interface.
	* Returns a consumer interface which will be used by the supplier
	*/
       supp_admin = _for_suppliers(evchObj, &ev);
       evcon_if = EventComm_EventConnectionNew();
       cons_if = _add_push_supplier(supp_admin, &ev, evcon_if);

      /* let the cell object know what the consumer_if is */
      _setConsumerIf(cellObj, &ev, cons_if);

       /* Write out the string representations of the object references */
       rc = write_obj_ref(cellObj_proxy, "cell.rep");
       rc = write_obj_ref(evchObj_proxy, "event.rep");
       if (rc) exit(1);

       /* Now call loop until deactivation */
       printf("Event Server going into the execute_request_loop\n");
       SOMOA_execute_request_loop(SOMD_SOMOAObject, &ev, SOMD_WAIT);
       printf("Event Server Terminating\n");
       _somFree(cellObj);
       _somFree(evchObj);
    }

    return 0;
}


int  write_obj_ref(SOMDObject objref, char *file)
{
    FILE *fd;
    char *objRefStr;

    objRefStr = ORB_object_to_string (SOMD_ORBObject, &ev, objref);

    if ((fd = fopen (file, "w")) == (FILE *) NULL)
    {
	printf ("Unable to create file %s, errno %d\n", file, errno);
	return -1;
    }

    fwrite ((void *) objRefStr, sizeof (char), strlen (objRefStr), fd);

    ORBfree (objRefStr);
    fclose (fd);
    return (0);
}


void exitUsage(char *prog)
{
    printf("\n\n Usage: %s <impl alias> \n\n", prog);
    exit(-1);
}
